	function A = lp_atten_epb(Z, NIN, Z_vec, Amax)

	% Calculates the loss L(Z_vec) in Z-frequencies Z_vec given
	% a attenuation pole vector Z for the LP case with equiripple passband.
	% Also the number of attenuation poles at infinity NIN is required.
	% function[A] = lp_atten_epb(Z,NIN,Z_vec,Amax)

	%	Author: 		Per Loewenborg 1999-03-22
	%	Modified by: 	LW, 2007-01-14
	%	Copyright:		by authors - not released for commercial use
	%	Version 		1.0 
	%	Known bugs:		None
	
	L = ones(1,length(Z_vec));
	N = length(Z);
	for k = 1:N
		L = L.*(Z_vec+Z(k));
		L = L./(Z_vec-Z(k)); 
	end
	L = L.*( (Z_vec+1).^(NIN/2) );
	L = L./( (Z_vec-1).^(NIN/2) );
	ep_sqred = (10^(0.1*Amax)) - 1;
	A = 10*log10(1 + ( (ep_sqred/4)*( (abs(L)+(1./abs(L))).^2 )) );
